#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// repeat patterns 001Mod01.fsh    by   Koji   
//https://www.shadertoy.com/view/wcVGWR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec4 FC = vec4(fragCoord.xy, 0.0, 0.0);

    float time = iTime;
    float r = 0.5 + 0.15 * sin(time + 0.0);
    float g = 0.5 + 0.455 * sin(time * 2.094395);
    float b = 0.5 + 0.75 * sin(time * 4.188790);
    vec4 time_varying_color_base = vec4(r, g, b, 0.345);
    
    vec4 o_for_calc = time_varying_color_base;
    o_for_calc += vec4(cos(2.0 * iTime));

    vec4 fc_div         = FC/45.725 ;
    vec4 fc_yxxx           = vec4(FC.y, FC.x, FC.x, FC.x);
    vec4 sin_term          = sin(fc_yxxx / 11.5);
    vec4 o_squared         = o_for_calc * o_for_calc;
    vec4 o_denominator     = vec4(2.0) + o_squared;
    vec4 o_special_term    = o_for_calc / o_denominator;
    vec4 product_term      = sin_term * o_special_term;
    vec4 sum_for_fract     = fc_div + product_term;
    vec4 U = abs(8.0 * fract(sum_for_fract) - 4.0);

    vec4 u_based_pattern = vec4(U.xxxx * U.y); // Will be grayscale, values can be > 1.0


    vec4 final_color_mix = mix(time_varying_color_base, clamp(u_based_pattern,0.0,1.0), 0.7); 
    //vec4 final_color_clamp = clamp(time_varying_color_base*0.5 + u_based_pattern*0.5, 0.0, 1.0)* 1.1;


    fragColor = final_color_mix;
////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

